/* AMX Mod X
*   Redirect Bullet on TA
*
* (c) Copyright 2006 by VEN
*
* This file is provided as is (no warranties)
*/

// uncomment to enable bullet redirection to the specific body part, valid body part values:
// HIT_HEAD, HIT_CHEST, HIT_STOMACH, HIT_LEFTARM, HIT_RIGHTARM, HIT_LEFTLEG, HIT_RIGHTLEG
//#define REDIRECT_TO HIT_HEAD

#include <amxmodx>
#include <fakemeta>

public plugin_init() {
	register_plugin("Redirect Bullet on TA", "0.1", "VEN")
	register_forward(FM_TraceLine, "forward_trace_line")
}

public forward_trace_line(Float:start[3], Float:dest[3], ignore_monsters, id, ptr) {
	if (!is_user_alive(id) || !(pev(id, pev_button) & IN_ATTACK))
		return FMRES_IGNORED

	engfunc(EngFunc_TraceLine, start, dest, ignore_monsters, id, ptr)
	new id2 = get_tr2(ptr, TR_pHit)
	if (!(id2 != id && is_user_alive(id2) && get_user_team(id2) == get_user_team(id)))
		return FMRES_IGNORED

	set_tr2(ptr, TR_pHit, id)

#if defined REDIRECT_TO
	set_tr2(ptr, TR_iHitgroup, REDIRECT_TO)
#endif

	return FMRES_SUPERCEDE
}
